/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.content.bank.blaze_banker;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import dev.ithundxr.createnumismatics.Numismatics;
import dev.ithundxr.createnumismatics.content.backend.BankAccount;
import dev.ithundxr.createnumismatics.content.backend.Trusted;
import dev.ithundxr.createnumismatics.content.backend.trust_list.TrustListContainer;
import dev.ithundxr.createnumismatics.content.backend.trust_list.TrustListHolder;
import dev.ithundxr.createnumismatics.content.bank.blaze_banker.BankAccountBehaviour;
import dev.ithundxr.createnumismatics.content.bank.blaze_banker.BlazeBankerMenu;
import dev.ithundxr.createnumismatics.content.bank.blaze_banker.BlazeBankerScreen;
import dev.ithundxr.createnumismatics.registry.NumismaticsMenuTypes;
import dev.ithundxr.createnumismatics.util.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlazeBankerBlockEntity
extends SmartBlockEntity
implements Trusted,
TrustListHolder,
MenuProvider {
    protected LerpedFloat headAnimation;
    protected LerpedFloat headAngle;
    private int clientsideBalance = 0;
    private int lastSentBalance = 0;
    protected BankAccountBehaviour bankAccountBehaviour;
    @Nullable
    protected UUID owner;
    @Nullable
    protected String label;
    protected final List<UUID> trustList = new ArrayList<UUID>();
    public final TrustListContainer trustListContainer = new TrustListContainer(this.trustList, this::onTrustListChanged);
    private boolean delayedDataSync = false;

    public String getLabel() {
        if (this.label != null && this.label.isEmpty()) {
            this.label = null;
        }
        return this.label;
    }

    public void setLabel(String label) {
        if (label.isEmpty()) {
            label = null;
        }
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.getAccount().setLabel(label);
        }
        this.label = label;
        this.notifyUpdate();
    }

    public BlazeBankerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.headAnimation = LerpedFloat.linear();
        this.headAngle = LerpedFloat.angular();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void tickAnimation() {
        boolean active = Minecraft.m_91087_().f_91080_ instanceof BlazeBankerScreen;
        float target = 0.0f;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && !player.m_20145_()) {
            double z;
            double x;
            if (this.isVirtual()) {
                x = -4.0;
                z = -10.0;
            } else {
                x = player.m_20185_();
                z = player.m_20189_();
            }
            double dx = x - ((double)this.m_58899_().m_123341_() + 0.5);
            double dz = z - ((double)this.m_58899_().m_123343_() + 0.5);
            target = AngleHelper.deg((double)(-Mth.m_14136_((double)dz, (double)dx))) - 90.0f;
        }
        target = this.headAngle.getValue() + AngleHelper.getShortestAngleDiff((double)this.headAngle.getValue(), (double)target);
        this.headAngle.chase((double)target, 0.25, LerpedFloat.Chaser.exp((double)5.0));
        this.headAngle.tickChaser();
        this.headAnimation.chase(active ? 1.0 : 0.0, 0.25, LerpedFloat.Chaser.exp((double)0.25));
        this.headAnimation.tickChaser();
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.bankAccountBehaviour = new BankAccountBehaviour(this);
        behaviours.add(this.bankAccountBehaviour);
    }

    private void onTrustListChanged() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        BankAccount account = this.getAccount();
        account.updateTrustList(accountTrustList -> {
            accountTrustList.clear();
            accountTrustList.add(this.owner);
            accountTrustList.addAll(this.trustList);
        });
        this.notifyUpdate();
    }

    public void lazyTick() {
        super.lazyTick();
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        if (this.delayedDataSync) {
            this.delayedDataSync = false;
            this.sendData();
        }
        if (this.owner != null && !this.getAccount().isAuthorized(this.owner)) {
            this.onTrustListChanged();
        }
        if (this.lastSentBalance != this.getAccount().getBalance()) {
            this.lastSentBalance = this.getAccount().getBalance();
            this.sendData();
        }
    }

    public void tick() {
        super.tick();
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            this.tickAnimation();
            if (!this.isVirtual()) {
                this.spawnParticles(BlazeBurnerBlock.HeatLevel.KINDLED, 1.0);
            }
            return;
        }
    }

    protected void spawnParticles(BlazeBurnerBlock.HeatLevel heatLevel, double burstMult) {
        if (this.f_58857_ == null) {
            return;
        }
        if (heatLevel == BlazeBurnerBlock.HeatLevel.NONE) {
            return;
        }
        RandomSource r = this.f_58857_.m_213780_();
        Vec3 c = VecHelper.getCenterOf((Vec3i)this.f_58858_);
        Vec3 v = c.m_82549_(VecHelper.offsetRandomly((Vec3)Vec3.f_82478_, (RandomSource)r, (float)0.125f).m_82542_(1.0, 0.0, 1.0));
        if (r.m_188503_(4) != 0) {
            return;
        }
        boolean empty = this.f_58857_.m_8055_(this.f_58858_.m_7494_()).m_60812_((BlockGetter)this.f_58857_, this.f_58858_.m_7494_()).m_83281_();
        if (empty || r.m_188503_(8) == 0) {
            this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123755_, v.f_82479_, v.f_82480_, v.f_82481_, 0.0, 0.0, 0.0);
        }
        double yMotion = empty ? 0.0625 : r.m_188500_() * (double)0.0125f;
        Vec3 v2 = c.m_82549_(VecHelper.offsetRandomly((Vec3)Vec3.f_82478_, (RandomSource)r, (float)0.5f).m_82542_(1.0, 0.25, 1.0).m_82541_().m_82490_((empty ? 0.25 : 0.5) + r.m_188500_() * 0.125)).m_82520_(0.0, 0.5, 0.0);
        if (heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.SEETHING)) {
            this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123745_, v2.f_82479_, v2.f_82480_, v2.f_82481_, 0.0, yMotion, 0.0);
        } else if (heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.FADING)) {
            this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123744_, v2.f_82479_, v2.f_82480_, v2.f_82481_, 0.0, yMotion, 0.0);
        }
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        if (this.owner != null) {
            tag.m_128362_("Owner", this.owner);
        }
        if (!this.trustListContainer.m_7983_()) {
            tag.m_128365_("TrustListInv", (Tag)this.trustListContainer.save(new CompoundTag()));
        }
        if (this.getLabel() != null) {
            tag.m_128359_("Label", this.getLabel());
        }
        if (clientPacket && this.hasAccount()) {
            tag.m_128405_("Balance", this.getAccount().getBalance());
        }
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.owner = tag.m_128403_("Owner") ? tag.m_128342_("Owner") : null;
        this.trustListContainer.m_6211_();
        this.trustList.clear();
        if (tag.m_128425_("TrustListInv", 10)) {
            this.trustListContainer.load(tag.m_128469_("TrustListInv"));
        }
        if (clientPacket) {
            this.clientsideBalance = tag.m_128451_("Balance");
        }
        this.setLabel(tag.m_128461_("Label"));
    }

    public BankAccount getAccount() {
        if (this.m_58901_()) {
            Numismatics.LOGGER.error("Tried to get account from removed banker!");
            return null;
        }
        if (this.bankAccountBehaviour == null) {
            return null;
        }
        return this.bankAccountBehaviour.getAccount();
    }

    public boolean hasAccount() {
        if (this.m_58901_()) {
            Numismatics.LOGGER.error("Tried to check account from removed banker!");
            return false;
        }
        if (this.bankAccountBehaviour == null) {
            return false;
        }
        return this.bankAccountBehaviour.hasAccount();
    }

    @Override
    public boolean isTrustedInternal(Player player) {
        if (Utils.isDevEnv()) {
            return player.m_6844_(EquipmentSlot.FEET).m_150930_(Items.f_42479_);
        }
        return this.owner == null || this.owner.equals(player.m_20148_()) || this.trustList.contains(player.m_20148_());
    }

    @Override
    public ImmutableList<UUID> getTrustList() {
        return ImmutableList.copyOf(this.trustList);
    }

    @Override
    public Container getTrustListBackingContainer() {
        return this.trustListContainer;
    }

    void notifyDelayedDataSync() {
        this.delayedDataSync = true;
    }

    @NotNull
    public Component m_5446_() {
        return Components.translatable((String)"block.numismatics.blaze_banker");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return new BlazeBankerMenu((MenuType)NumismaticsMenuTypes.BLAZE_BANKER.get(), i, inventory, this);
    }

    @NotNull
    public String getLabelNonNull() {
        return this.getLabel() == null ? "Blaze Banker" : this.getLabel();
    }

    public UUID getAccountId() {
        if (this.bankAccountBehaviour == null) {
            return null;
        }
        return this.bankAccountBehaviour.getAccountUUID();
    }

    public int getClientsideBalance() {
        return this.clientsideBalance;
    }

    @Override
    public void openTrustListMenu(ServerPlayer player) {
        if (!this.isTrusted((Player)player)) {
            return;
        }
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        Utils.openScreen(player, this, arg_0 -> ((BlazeBankerBlockEntity)this).sendToMenu(arg_0));
    }
}

